;
(function($, window) {
    let ele = null,
        exzoom_img_box = null,
        boxWidth = null,
        boxHeight = null,
        exzoom_img_ul_outer = null,
        exzoom_img_ul = null,
        exzoom_img_ul_position = 0,
        exzoom_img_ul_width = 0,
        exzoom_img_ul_max_margin = 0,
        exzoom_nav = null,
        exzoom_nav_inner = null,
        navHightClass = "current",
        exzoom_navSpan = null,
        navHeightWithBorder = null,
        images = null,
        exzoom_prev_btn = null,
        exzoom_next_btn = null,
        imgNum = 0,
        imgIndex = 0,
        imgArr = [],
        exzoom_zoom = null,
        exzoom_main_img = null,
        exzoom_zoom_outer = null,
        exzoom_preview = null,
        exzoom_preview_img = null,
        autoPlayInterval = null,
        startX = 0,
        startY = 0,
        endX = 0,
        endY = 0,
        g = {},
        defaults = {
            "navWidth": 60,
            "navHeight": 60,
            "navItemNum": 5,
            "navItemMargin": 7,
            "navBorder": 1,
            "autoPlay": true,
            "autoPlayTimeout": 2000,
        };


    let methods = {
        init: function(options) {
            let opts = $.extend({}, defaults, options);

            ele = this;
            exzoom_img_box = ele.find(".exzoom_img_box");
            exzoom_img_ul = ele.find(".exzoom_img_ul");
            exzoom_nav = ele.find(".exzoom_nav");
            exzoom_prev_btn = ele.find(".exzoom_prev_btn");
            exzoom_next_btn = ele.find(".exzoom_next_btn");

            boxHeight = boxWidth = ele.outerWidth();
            g.navWidth = opts.navWidth;
            g.navHeight = opts.navHeight;
            g.navBorder = opts.navBorder;
            g.navItemMargin = opts.navItemMargin;
            g.navItemNum = opts.navItemNum;
            g.autoPlay = opts.autoPlay;
            g.autoPlayTimeout = opts.autoPlayTimeout;

            images = exzoom_img_box.find("img");
            imgNum = images.length;
            checkLoadedAllImages(images)
        },
        prev: function() {
            moveLeft()
        },
        next: function() {
            moveRight();
        },
        setImg: function() {
            let url = arguments[0];

            getImageSize(url, function(width, height) {
                exzoom_preview_img.attr("src", url);
                exzoom_main_img.attr("src", url);

                if (exzoom_img_ul.find("li").length === imgNum + 1) {
                    exzoom_img_ul.find("li:last").remove();
                }
                exzoom_img_ul.append('<li style="width: ' + boxWidth + 'px;">' +
                    '<img src="' + url + '"></li>');

                let image_prop = copute_image_prop(url, width, height);
                previewImg(image_prop);
            });
        },
    };

    $.fn.extend({
        "exzoom": function(method, options) {
            if (arguments.length === 0 || (typeof method === 'object' && !options)) {
                if (this.length === 0) {
                    $.error('Selector is empty when call jQuery.exzomm');
                } else {
                    return methods.init.apply(this, arguments);
                }
            } else if (methods[method]) {
                return methods[method].apply(this, Array.prototype.slice.call(arguments, 1));
            } else {
                $.error('Method ' + method + 'does not exist on jQuery.exzomm');
            }
        }
    });


    function init() {
        exzoom_img_box.append("<div class='exzoom_img_ul_outer'></div>");
        exzoom_nav.append("<p class='exzoom_nav_inner'></p>");
        exzoom_img_ul_outer = exzoom_img_box.find(".exzoom_img_ul_outer");
        exzoom_nav_inner = exzoom_nav.find(".exzoom_nav_inner");

        exzoom_img_ul_outer.append(exzoom_img_ul);

        for (let i = 0; i < imgNum; i++) {
            imgArr[i] = copute_image_prop(images.eq(i));
            console.log(imgArr[i]);
            let li = exzoom_img_ul.find("li").eq(i);
            li.css("width", boxWidth);
            li.find("img").css({
                "margin-top": imgArr[i][5],
                "width": imgArr[i][3]
            });
        }

        exzoom_navSpan = exzoom_nav.find("span");
        navHeightWithBorder = g.navBorder * 2 + g.navHeight;
        g.exzoom_navWidth = (navHeightWithBorder + g.navItemMargin) * g.navItemNum;
        g.exzoom_nav_innerWidth = (navHeightWithBorder + g.navItemMargin) * imgNum;

        exzoom_navSpan.eq(imgIndex).addClass(navHightClass);
        exzoom_nav.css({
            "height": navHeightWithBorder + "px",
            "width": boxWidth - exzoom_prev_btn.width() - exzoom_next_btn.width(),
        });
        exzoom_nav_inner.css({
            "width": g.exzoom_nav_innerWidth + "px"
        });
        exzoom_navSpan.css({
            "margin-left": g.navItemMargin + "px",
            "width": g.navWidth + "px",
            "height": g.navHeight + "px",
        });

        exzoom_img_ul_width = boxWidth * imgNum;
        exzoom_img_ul_max_margin = boxWidth * (imgNum - 1);
        exzoom_img_ul.css("width", exzoom_img_ul_width);
        exzoom_img_box.append(`
<div class='exzoom_zoom_outer'>
    <span class='exzoom_zoom'></span>
</div>
<p class='exzoom_preview'>
    <img class='exzoom_preview_img' src='' />
</p>
            `);
        exzoom_zoom = exzoom_img_box.find(".exzoom_zoom");
        exzoom_main_img = exzoom_img_box.find(".exzoom_main_img");
        exzoom_zoom_outer = exzoom_img_box.find(".exzoom_zoom_outer");
        exzoom_preview = exzoom_img_box.find(".exzoom_preview");
        exzoom_preview_img = exzoom_img_box.find(".exzoom_preview_img");

        exzoom_img_box.css({
            "width": boxHeight + "px",
            "height": boxHeight + "px",
        });

        exzoom_img_ul_outer.css({
            "width": boxHeight + "px",
            "height": boxHeight + "px",
        });

        exzoom_preview.css({
            "width": boxHeight + "px",
            "height": boxHeight + "px",
            "left": boxHeight + 5 + "px",
        });

        previewImg(imgArr[imgIndex]);
        autoPlay();
        bindingEvent();
    }

    /**
     *
     * @param images
     */
    function checkLoadedAllImages(images) {
        let timer = setInterval(function() {
            let loaded_images_counter = 0;
            let all_images_num = images.length;
            images.each(function() {
                if (this.complete) {
                    loaded_images_counter++;
                }
            });
            if (loaded_images_counter === all_images_num) {
                clearInterval(timer);
                init();
            }
        }, 100)
    }


    function getCursorCoords(event) {
        let e = event || window.event;
        let coords_data = e,
            x,
            y;

        if (e["touches"] !== undefined) {
            if (e["touches"].length > 0) {
                coords_data = e["touches"][0];
            }
        }

        x = coords_data.clientX || coords_data.pageX;
        y = coords_data.clientY || coords_data.pageY;

        return { 'x': x, 'y': y }
    }


    function checkNewPositionLimit(new_position) {
        if (-new_position > exzoom_img_ul_max_margin) {
            new_position = -exzoom_img_ul_max_margin;
            imgIndex = 0;
        } else if (new_position > 0) {
            new_position = 0;
        }
        return new_position
    }

    function bindingEvent() {
        exzoom_img_ul.on("touchstart", function(event) {
            let coords = getCursorCoords(event);
            startX = coords.x;
            startY = coords.y;

            let left = exzoom_img_ul.css("left");
            exzoom_img_ul_position = parseInt(left);

            window.clearInterval(autoPlayInterval);
        });

        exzoom_img_ul.on("touchmove", function(event) {
            let coords = getCursorCoords(event);
            let new_position;
            endX = coords.x;
            endY = coords.y;

            new_position = exzoom_img_ul_position + endX - startX;
            new_position = checkNewPositionLimit(new_position);
            exzoom_img_ul.css("left", new_position);

        });

        exzoom_img_ul.on("touchend", function(event) {
            console.log(endX < startX);
            if (endX < startX) {
                moveRight();
            } else if (endX > startX) {
                moveLeft();
            }

            autoPlay();
        });

        exzoom_zoom_outer.on("mousedown", function(event) {
            let coords = getCursorCoords(event);
            startX = coords.x;
            startY = coords.y;

            let left = exzoom_img_ul.css("left");
            exzoom_img_ul_position = parseInt(left);
        });

        exzoom_zoom_outer.on("mouseup", function(event) {
            let offset = ele.offset();

            if (startX - offset.left < boxWidth / 2) {

                moveLeft();
            } else if (startX - offset.left > boxWidth / 2) {

                moveRight();
            }
        });


        ele.on("mouseenter", function() {
            window.clearInterval(autoPlayInterval);
        });

        ele.on("mouseleave", function() {
            autoPlay();
        });

        exzoom_zoom_outer.on("mouseenter", function() {
            exzoom_zoom.css("display", "block");
            exzoom_preview.css("display", "block");
        });

        exzoom_zoom_outer.on("mousemove", function(e) {
            let width_limit = exzoom_zoom.width() / 2,
                max_X = exzoom_zoom_outer.width() - width_limit,
                max_Y = exzoom_zoom_outer.height() - width_limit,
                current_X = e.pageX - exzoom_zoom_outer.offset().left,
                current_Y = e.pageY - exzoom_zoom_outer.offset().top,
                move_X = current_X - width_limit,
                move_Y = current_Y - width_limit;

            if (current_X <= width_limit) {
                move_X = 0;
            }
            if (current_X >= max_X) {
                move_X = max_X - width_limit;
            }
            if (current_Y <= width_limit) {
                move_Y = 0;
            }
            if (current_Y >= max_Y) {
                move_Y = max_Y - width_limit;
            }
            exzoom_zoom.css({ "left": move_X + "px", "top": move_Y + "px" });

            exzoom_preview_img.css({
                "left": -move_X * exzoom_preview.width() / exzoom_zoom.width() + "px",
                "top": -move_Y * exzoom_preview.width() / exzoom_zoom.width() + "px"
            });
        });

        exzoom_zoom_outer.on("mouseleave", function() {
            exzoom_zoom.css("display", "none");
            exzoom_preview.css("display", "none");
        });

        exzoom_preview.on("mouseenter", function() {
            exzoom_zoom.css("display", "none");
            exzoom_preview.css("display", "none");
        });

        exzoom_next_btn.on("click", function() {
            moveRight();
        });
        exzoom_prev_btn.on("click", function() {
            moveLeft();
        });

        exzoom_navSpan.hover(function() {
            imgIndex = $(this).index();
            move(imgIndex);
        });
    }

    /**
     * @param direction:
     */
    function move(direction) {
        if (typeof direction === "undefined") {
            alert("exzoom 中的 move 函数的 direction 参数必填");
        }
        if (imgIndex > imgArr.length - 1) {
            imgIndex = 0;
        }

        exzoom_navSpan.eq(imgIndex).addClass(navHightClass).siblings().removeClass(navHightClass);

        let exzoom_nav_width = exzoom_nav.width();
        let nav_item_width = g.navItemMargin + g.navWidth + g.navBorder * 2;
        let new_nav_offset = 0;

        let temp = nav_item_width * (imgIndex + 1);
        if (temp > exzoom_nav_width) {
            new_nav_offset = boxWidth - temp;
        }

        exzoom_nav_inner.css({
            "left": new_nav_offset
        });

        let new_position = -boxWidth * imgIndex;
        new_position = checkNewPositionLimit(new_position);
        exzoom_img_ul.stop().animate({ "left": new_position }, 500);
        previewImg(imgArr[imgIndex]);
    }


    function moveRight() {
        imgIndex++;
        if (imgIndex > imgNum) {
            imgIndex = imgNum;
        }
        move("right");
    }


    function moveLeft() {
        imgIndex--;
        if (imgIndex < 0) {
            imgIndex = 0;
        }
        move("left");
    }


    function autoPlay() {
        if (g.autoPlay) {
            autoPlayInterval = window.setInterval(function() {
                if (imgIndex >= imgNum) {
                    imgIndex = 0;
                }
                imgIndex++;
                move("right");
            }, g.autoPlayTimeout);
        }
    }

    function previewImg(image_prop) {
        if (image_prop === undefined) {
            return
        }
        exzoom_preview_img.attr("src", image_prop[0]);

        exzoom_main_img.attr("src", image_prop[0])
            .css({
                "width": image_prop[3] + "px",
                "height": image_prop[4] + "px"
            });
        exzoom_zoom_outer.css({
            "width": image_prop[3] + "px",
            "height": image_prop[4] + "px",
            "top": image_prop[5] + "px",
            "left": image_prop[6] + "px",
            "position": "relative"
        });
        exzoom_zoom.css({
            "width": image_prop[7] + "px",
            "height": image_prop[7] + "px"
        });
        exzoom_preview_img.css({
            "width": image_prop[8] + "px",
            "height": image_prop[9] + "px"
        });
    }

    /**
     * @param url
     * @param callback
     */
    function getImageSize(url, callback) {
        let img = new Image();
        img.src = url;

        if (typeof callback !== "undefined") {
            if (img.complete) {
                callback(img.width, img.height);
            } else {

                img.on("load", function() {
                    callback(img.width, img.height);
                })
            }
        } else {
            return {
                width: img.width,
                height: img.height
            }
        }
    }

    /**
     * @param image :
     * @param width :
     * @param height :
     * @returns {Array}
     */
    function copute_image_prop(image, width, height) {
        let src;
        let res = [];

        if (typeof image === "string") {
            src = image;
        } else {
            src = image.attr("src");
            let size = getImageSize(src);
            width = size.width;
            height = size.height;
        }

        res[0] = src;
        res[1] = width;
        res[2] = height;
        let img_scale = res[1] / res[2];

        if (img_scale === 1) {
            res[3] = boxHeight; //width
            res[4] = boxHeight; //height
            res[5] = 0; //top
            res[6] = 0; //left
            res[7] = boxHeight / 2;
            res[8] = boxHeight * 2; //width
            res[9] = boxHeight * 2; //height
            exzoom_nav_inner.append(`<span><img src="${src}" width="${g.navWidth }" height="${g.navHeight }"/></span>`);
        } else if (img_scale > 1) {
            res[3] = boxHeight; //width
            res[4] = boxHeight / img_scale;
            res[5] = (boxHeight - res[4]) / 2;
            res[6] = 0; //left
            res[7] = res[4] / 2;
            res[8] = boxHeight * 2 * img_scale; //width
            res[9] = boxHeight * 2; //height
            let top = (g.navHeight - (g.navWidth / img_scale)) / 2;
            exzoom_nav_inner.append(`<span><img src="${src}" width="${g.navWidth }" style='top:${top}px;' /></span>`);
        } else if (img_scale < 1) {
            res[3] = boxHeight * img_scale; //width
            res[4] = boxHeight; //height
            res[5] = 0; //top
            res[6] = (boxHeight - res[3]) / 2;
            res[7] = res[3] / 2;
            res[8] = boxHeight * 2; //width
            res[9] = boxHeight * 2 / img_scale;
            let top = (g.navWidth - (g.navHeight * img_scale)) / 2;
            exzoom_nav_inner.append(`<span><img src="${src}" height="${g.navHeight}" style="left:${top}px;"/></span>`);
        }

        return res;
    }

    // 闭包结束
})(jQuery, window);