<?php
    $setting = App\Models\Setting::first();
?>

<div class="main-sidebar">
    <aside id="sidebar-wrapper">
      <div class="sidebar-brand">
        <a href="<?php echo e(route('admin.dashboard')); ?>">
            <img class="logo" src="<?php echo e(asset($setting->logo)); ?>" alt="logo"/>
        </a>
      </div>

      <div class="sidebar-brand sidebar-brand-sm">
        <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e($setting->sidebar_sm_header); ?></a>
      </div>

      <ul class="sidebar-menu">
          <li class="<?php echo e(Route::is('admin.dashboard') ? 'active' : ''); ?>">
              <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
                  <div class="icon">
                    <i class="fas fa-home"></i>
                  </div>
                  <span><?php echo e(__('admin.Dashboard')); ?></span>
               </a>
          </li>


          <li class="nav-item dropdown <?php echo e(Route::is('admin.all-order') || Route::is('admin.order-show') || Route::is('admin.pending-order') || Route::is('admin.pregress-order') || Route::is('admin.delivered-order') ||  Route::is('admin.completed-order') || Route::is('admin.declined-order') || Route::is('admin.cash-on-delivery')  ? 'active' : ''); ?>">

            <a href="#" class="nav-link has-dropdown">

             <div class="icon">
                                <i class="fas fa-shopping-cart"></i>
                              </div>
           <span><?php echo e(__('admin.Orders')); ?></span></a>
            <ul class="dropdown-menu">

              <li class="<?php echo e(Route::is('admin.all-order') || Route::is('admin.order-show') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.all-order')); ?>"><?php echo e(__('admin.All Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.pending-order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pending-order')); ?>"><?php echo e(__('admin.Pending Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.pregress-order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pregress-order')); ?>"><?php echo e(__('admin.Progress Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.delivered-order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.delivered-order')); ?>"><?php echo e(__('admin.Delivered Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.completed-order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.completed-order')); ?>"><?php echo e(__('admin.Completed Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.declined-order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.declined-order')); ?>"><?php echo e(__('admin.Declined Orders')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.cash-on-delivery') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.cash-on-delivery')); ?>"><?php echo e(__('admin.Cash On Delivery')); ?></a></li>

            </ul>

          </li>
          <li class="nav-item dropdown <?php echo e(Route::is('admin.customer-list') || Route::is('admin.customer-show') || Route::is('admin.pending-customer-list') || Route::is('admin.seller-list') || Route::is('admin.seller-show') || Route::is('admin.pending-seller-list') || Route::is('admin.seller-shop-detail') || Route::is('admin.seller-reviews') || Route::is('admin.show-seller-review-details') || Route::is('admin.send-email-to-seller') || Route::is('admin.email-history') || Route::is('admin.product-by-seller') || Route::is('admin.send-email-to-all-seller') || Route::is('admin.send-email-to-all-customer') ? 'active' : ''); ?>">

                <a href="#" class="nav-link has-dropdown">
                <div class="icon">
                <i class="fas fa-user"></i>
                </div>
                <span><?php echo e(__('admin.Users')); ?></span></a>

                <ul class="dropdown-menu">

                    <li class="<?php echo e(Route::is('admin.customer-list') || Route::is('admin.customer-show') || Route::is('admin.send-email-to-all-customer') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.customer-list')); ?>"><?php echo e(__('admin.Customer List')); ?></a></li>

                    <li class="<?php echo e(Route::is('admin.pending-customer-list') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pending-customer-list')); ?>"><?php echo e(__('admin.Pending Customers')); ?></a></li>

                    <li class="<?php echo e(Route::is('admin.seller-list') || Route::is('admin.seller-show') || Route::is('admin.seller-shop-detail') || Route::is('admin.seller-reviews') || Route::is('admin.show-seller-review-details') || Route::is('admin.send-email-to-seller') || Route::is('admin.email-history') || Route::is('admin.product-by-seller') || Route::is('admin.send-email-to-all-seller') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seller-list')); ?>"><?php echo e(__('admin.Seller List')); ?></a></li>

                    <li class="<?php echo e(Route::is('admin.pending-seller-list') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pending-seller-list')); ?>"><?php echo e(__('admin.Pending Sellers')); ?></a></li>

                </ul>

            </li>



          <li class="nav-item dropdown <?php echo e(Route::is('admin.product-category.*') || Route::is('admin.product-sub-category.*') || Route::is('admin.product-child-category.*') || Route::is('admin.mega-menu-category.*') || Route::is('admin.mega-menu-sub-category') || Route::is('admin.create-mega-menu-sub-category') || Route::is('admin.edit-mega-menu-sub-category') || Route::is('admin.mega-menu-banner') || Route::is('admin.popular-category') || Route::is('admin.featured-category') ? 'active' : ''); ?>">

            <p class="s-divide"><?php echo e(__('admin.Products')); ?></p>
            <a href="#" class="nav-link has-dropdown">

             <div class="icon">
                                    <i class="fas fa-th-large"></i>
                                          </div>
            <span><?php echo e(__('admin.Manage Categories')); ?></span></a>
            <ul class="dropdown-menu">

              <li class="<?php echo e(Route::is('admin.product-category.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-category.index')); ?>"><?php echo e(__('admin.Categories')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.product-sub-category.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-sub-category.index')); ?>"><?php echo e(__('admin.Sub Categories')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.product-child-category.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-child-category.index')); ?>"><?php echo e(__('admin.Child Categories')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.mega-menu-category.*') || Route::is('admin.mega-menu-sub-category') || Route::is('admin.create-mega-menu-sub-category') || Route::is('admin.edit-mega-menu-sub-category') || Route::is('admin.mega-menu-banner') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.mega-menu-category.index')); ?>"><?php echo e(__('admin.Mega Menu Category')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.popular-category') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.popular-category')); ?>"><?php echo e(__('admin.Popular Category')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.featured-category') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.featured-category')); ?>"><?php echo e(__('admin.Featured Category')); ?></a></li>

            </ul>

          </li>





          <li class="nav-item dropdown <?php echo e(Route::is('admin.product.*') || Route::is('admin.product-brand.*') || Route::is('admin.product-variant') || Route::is('admin.create-product-variant') || Route::is('admin.edit-product-variant') || Route::is('admin.product-gallery') || Route::is('admin.product-variant-item') || Route::is('admin.create-product-variant-item') || Route::is('admin.edit-product-variant-item') || Route::is('admin.product-review') || Route::is('admin.show-product-review') || Route::is('admin.seller-product') || Route::is('admin.seller-pending-product') || Route::is('admin.wholesale') || Route::is('admin.create-wholesale') || Route::is('admin.edit-wholesale') || Route::is('admin.product-highlight') ||  Route::is('admin.product-report') || Route::is('admin.show-product-report') || Route::is('admin.specification-key.*') || Route::is('admin.stockout-product') || Route::is('admin.product-import') ? 'active' : ''); ?>">
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-th-large"></i>
            </div>
            <span><?php echo e(__('admin.Manage Products')); ?></span></a>
            <ul class="dropdown-menu">

            <li class="<?php echo e(Route::is('admin.product-brand.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-brand.index')); ?>"><?php echo e(__('admin.Brands')); ?></a></li>


            <li class="<?php echo e(Route::is('admin.product-import') ? 'active' : ''); ?>"><a  class="nav-link" href="<?php echo e(route('admin.product-import')); ?>"><?php echo e(__('admin.Product Import')); ?></a></li>


            <li><a class="nav-link" href="<?php echo e(route('admin.product.create')); ?>"><?php echo e(__('admin.Create Product')); ?></a></li>

            <li class="<?php echo e(Route::is('admin.product.*') || Route::is('admin.product-variant') || Route::is('admin.create-product-variant') || Route::is('admin.edit-product-variant') || Route::is('admin.product-gallery') || Route::is('admin.product-variant-item') || Route::is('admin.create-product-variant-item') || Route::is('admin.edit-product-variant-item') || Route::is('admin.wholesale') || Route::is('admin.create-wholesale') || Route::is('admin.edit-wholesale') || Route::is('admin.product-highlight') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product.index')); ?>"><?php echo e(__('admin.Products')); ?></a></li>

            <li class="<?php echo e(Route::is('admin.stockout-product') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.stockout-product')); ?>"><?php echo e(__('admin.Stock out')); ?></a></li>

            <li class="<?php echo e(Route::is('admin.seller-product') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seller-product')); ?>"><?php echo e(__('admin.Seller Products')); ?></a></li>

            <li class="<?php echo e(Route::is('admin.seller-pending-product') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seller-pending-product')); ?>"><?php echo e(__('admin.Seller Pending Products')); ?></a></li>

            <li class="<?php echo e(Route::is('admin.specification-key.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.specification-key.index')); ?>"><?php echo e(__('admin.Specification Key')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.product-review') || Route::is('admin.show-product-review') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-review')); ?>"><?php echo e(__('admin.Product Reviews')); ?></a></li>

              <li class="<?php echo e(Route::is('admin.product-report') || Route::is('admin.show-product-report') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.product-report')); ?>"><?php echo e(__('admin.Product Report')); ?></a></li>
            </ul>

          </li>

          <li class="<?php echo e(Route::is('admin.inventory') || Route::is('admin.stock-history') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.inventory')); ?>">
            <div class="icon">
                <i class="fas fa-th-large"></i>

            </div>
            <span><?php echo e(__('admin.Inventory')); ?></span></a>
          </li>
          <li class="nav-item dropdown <?php echo e(Route::is('admin.pos.index') || Route::is('admin.pos.bulk.order') ? 'active' : ''); ?>">
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-th-large"></i>
            </div>
            <span><?php echo e(__('admin.Pos')); ?></span></a>
            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.pos.index') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pos.index')); ?>"><?php echo e(__('admin.Add New Order')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.pos.bulk.order') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pos.bulk.order')); ?>"><?php echo e(__('admin.Bulk Order Accept')); ?></a></li>
            </ul>
          </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.flash-sale') || Route::is('admin.currency.*') || Route::is('admin.coupon.*') || Route::is('admin.payment-method') || Route::is('admin.flash-sale-product') ? 'active' : ''); ?>">
          <p class="s-divide"><?php echo e(__('admin.Shop Setup')); ?></p>
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-shopping-cart"></i>
            </div>
            <span><?php echo e(__('admin.Ecommerce')); ?></span></a>
            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.flash-sale') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.flash-sale')); ?>"><?php echo e(__('admin.Flash Sale')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.flash-sale-product') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.flash-sale-product')); ?>"><?php echo e(__('admin.Flash Sale Product')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.coupon.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.coupon.index')); ?>"><?php echo e(__('admin.Coupon')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.payment-method') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.payment-method')); ?>"><?php echo e(__('admin.Payment Method')); ?></a></li>
            </ul>

          </li>

          <li class="<?php echo e(Route::is('admin.advertisement') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.advertisement')); ?>">

          <div class="icon">
          <i class="fas fa-ad"></i>
          </div>
           <span><?php echo e(__('admin.Advertisement')); ?></span></a></li>
            <li class="nav-item dropdown <?php echo e(Route::is('admin.country.*') || Route::is('admin.state.*') || Route::is('admin.city.*') || Route::is('admin.country-import-page') || Route::is('admin.state-import-page') || Route::is('admin.city-import-page') || Route::is('admin.shipping-import-page') ? 'active' : ''); ?>">

                       <a href="#" class="nav-link has-dropdown">
                       <div class="icon">
                        <i class="fas fa-map-marker-alt"></i>
                       </div>
                      <span><?php echo e(__('admin.Locations')); ?></span></a>

                       <ul class="dropdown-menu">

                           <li class="<?php echo e(Route::is('admin.country.*') || Route::is('admin.country-import-page') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.country.index')); ?>"><?php echo e(__('admin.Country / Region')); ?></a></li>

                           <li class="<?php echo e(Route::is('admin.state.*') || Route::is('admin.state-import-page') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.state.index')); ?>"><?php echo e(__('admin.State / Province')); ?></a></li>

                           <li class="<?php echo e(Route::is('admin.city.*') || Route::is('admin.city-import-page') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.city.index')); ?>"><?php echo e(__('admin.City / Delivery Area')); ?></a></li>


                            <li class="<?php echo e(Route::is('admin.shipping.*') || Route::is('admin.shipping-import-page') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.shipping.index')); ?>"><?php echo e(__('admin.Shipping Rule')); ?></a></li>


                       </ul>

                     </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.withdraw-method.*') || Route::is('admin.seller-withdraw') || Route::is('admin.pending-seller-withdraw') || Route::is('admin.show-seller-withdraw')  ? 'active' : ''); ?>">

            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="far fa-newspaper"></i>
           </div>
            <span><?php echo e(__('admin.Withdraw Payment')); ?></span></a>

            <ul class="dropdown-menu">
                <li class="<?php echo e(Route::is('admin.withdraw-method.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.withdraw-method.index')); ?>"><?php echo e(__('admin.Withdraw Method')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.seller-withdraw') || Route::is('admin.show-seller-withdraw') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seller-withdraw')); ?>"><?php echo e(__('admin.Seller Withdraw')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.pending-seller-withdraw') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.pending-seller-withdraw')); ?>"><?php echo e(__('admin.Pending Seller Withdraw')); ?></a></li>
            </ul>

          </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.service.*') || Route::is('admin.maintainance-mode') || Route::is('admin.announcement') ||  Route::is('admin.slider.*') || Route::is('admin.home-page') || Route::is('admin.banner-image.index') || Route::is('admin.homepage-one-visibility') || Route::is('admin.cart-bottom-banner') || Route::is('admin.shop-page') || Route::is('admin.seo-setup') || Route::is('admin.menu-visibility') || Route::is('admin.product-detail-page') || Route::is('admin.default-avatar') || Route::is('admin.seller-conditions') || Route::is('admin.subscription-banner') || Route::is('admin.testimonial.*') || Route::is('admin.homepage-section-title') ? 'active' : ''); ?>">
           <p class="s-divide"><?php echo e(__('admin.Website Settings')); ?></p>
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-globe"></i>
            </div>
            <span><?php echo e(__('admin.Manage Website')); ?></span></a>
            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.seo-setup') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seo-setup')); ?>"><?php echo e(__('admin.SEO Setup')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.slider.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.slider.index')); ?>"><?php echo e(__('admin.Slider')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.shop-page') ? 'active' : ''); ?> d-none"><a class="nav-link" href="<?php echo e(route('admin.shop-page')); ?>"><?php echo e(__('admin.Shop Page')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.service.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.service.index')); ?>"><?php echo e(__('admin.Service')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.homepage-section-title') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.homepage-section-title')); ?>"><?php echo e(__('admin.Homepage Section Title')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.seller-conditions') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.seller-conditions')); ?>"><?php echo e(__('admin.Seller Conditions')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.testimonial.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.testimonial.index')); ?>"><?php echo e(__('admin.Testimonial')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.maintainance-mode') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.maintainance-mode')); ?>"><?php echo e(__('admin.Maintainance Mode')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.announcement') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.announcement')); ?>"><?php echo e(__('admin.Announcement')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.subscription-banner') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.subscription-banner')); ?>"><?php echo e(__('admin.Subscription Banner')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.image-content') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.image-content')); ?>"><?php echo e(__('admin.Image Content')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.default-avatar') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.default-avatar')); ?>"><?php echo e(__('admin.Default Avatar')); ?></a></li>

            </ul>

          </li>



          <li class="nav-item dropdown <?php echo e(Route::is('admin.footer.*') || Route::is('admin.social-link.*') || Route::is('admin.footer-link.*') || Route::is('admin.second-col-footer-link') || Route::is('admin.third-col-footer-link') ? 'active' : ''); ?>">

            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-th-large"></i>
            </div>

            <span><?php echo e(__('admin.Website Footer')); ?></span></a>

            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.footer.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.footer.index')); ?>"><?php echo e(__('admin.Footer')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.social-link.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.social-link.index')); ?>"><?php echo e(__('admin.Social Link')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.footer-link.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.footer-link.index')); ?>"><?php echo e(__('admin.First Column Link')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.second-col-footer-link') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.second-col-footer-link')); ?>"><?php echo e(__('admin.Second Column Link')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.third-col-footer-link') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.third-col-footer-link')); ?>"><?php echo e(__('admin.Third Column Link')); ?></a></li>

            </ul>

          </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.about-us.*') || Route::is('admin.custom-page.*') || Route::is('admin.terms-and-condition.*') || Route::is('admin.privacy-policy.*') || Route::is('admin.faq.*') || Route::is('admin.error-page.*') || Route::is('admin.contact-us.*') || Route::is('admin.login-page') ? 'active' : ''); ?>">

            <a href="#" class="nav-link has-dropdown">

            <div class="icon">
            <i class="fas fa-columns"></i>

            </div>
            <span><?php echo e(__('admin.Pages')); ?></span></a>
            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.about-us.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.about-us.index')); ?>"><?php echo e(__('admin.About Us')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.contact-us.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.contact-us.index')); ?>"><?php echo e(__('admin.Contact Us')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.custom-page.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.custom-page.index')); ?>"><?php echo e(__('admin.Custom Page')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.terms-and-condition.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.terms-and-condition.index')); ?>"><?php echo e(__('admin.Terms And Conditions')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.privacy-policy.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.privacy-policy.index')); ?>"><?php echo e(__('admin.Privacy Policy')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.faq.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.faq.index')); ?>"><?php echo e(__('admin.FAQ')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.error-page.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.error-page.index')); ?>"><?php echo e(__('admin.Error Page')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.login-page') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.login-page')); ?>"><?php echo e(__('admin.Login Page')); ?></a></li>
            </ul>

          </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.blog-category.*') || Route::is('admin.blog.*') || Route::is('admin.popular-blog.*') || Route::is('admin.blog-comment.*') ? 'active' : ''); ?>">

            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-th-large"></i>
            </div>
            <span><?php echo e(__('admin.Blogs')); ?></span></a>

            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.blog-category.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.blog-category.index')); ?>"><?php echo e(__('admin.Categories')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.blog.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.blog.index')); ?>"><?php echo e(__('admin.Blogs')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.popular-blog.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.popular-blog.index')); ?>"><?php echo e(__('admin.Popular Blogs')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.blog-comment.*') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.blog-comment.index')); ?>"><?php echo e(__('admin.Comments')); ?></a></li>

            </ul>

          </li>



          <li class="nav-item dropdown <?php echo e(Route::is('admin.email-configuration') || Route::is('admin.email-template') || Route::is('admin.edit-email-template') ? 'active' : ''); ?>">
           <p class="s-divide"><?php echo e(__('admin.Configuration')); ?></p>
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-envelope"></i>
            </div>
            <span><?php echo e(__('admin.Email Configuration')); ?></span></a>

            <ul class="dropdown-menu">

                <li class="<?php echo e(Route::is('admin.email-configuration') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.email-configuration')); ?>"><?php echo e(__('admin.Setting')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.email-template') || Route::is('admin.edit-email-template') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.email-template')); ?>"><?php echo e(__('admin.Email Template')); ?></a></li>

            </ul>

          </li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.sms-notification') || Route::is('admin.sms-template') || Route::is('admin.edit-sms-template') ? 'active' : ''); ?>">
            <a href="#" class="nav-link has-dropdown">

                <div class="icon">
                    <i class="fas fa-envelope"></i>
                </div>

                <span><?php echo e(__('admin.Sms Configuration')); ?></span></a>

            <ul class="dropdown-menu">
                <li class="<?php echo e(Route::is('admin.sms-notification') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.sms-notification')); ?>"><?php echo e(__('admin.Setting')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.sms-template') || Route::is('admin.edit-sms-template') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.sms-template')); ?>"><?php echo e(__('admin.Sms Template')); ?></a></li>
            </ul>
          </li>

          <li class="<?php echo e(Route::is('admin.subscriber') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.subscriber')); ?>">

                     <div class="icon">
                     <i class="fas fa-fire"></i>
                     </div>
                     <span><?php echo e(__('admin.Subscribers')); ?></span></a></li>

          <li class="nav-item dropdown <?php echo e(Route::is('admin.admin-language') || Route::is('admin.admin-validation-language') || Route::is('admin.website-language') || Route::is('admin.website-validation-language') ? 'active' : ''); ?>">
            <a href="#" class="nav-link has-dropdown">
            <div class="icon">
            <i class="fas fa-th-large"></i>
            </div>
            <span><?php echo e(__('admin.Language')); ?></span></a>

            <ul class="dropdown-menu">
                <li class="<?php echo e(Route::is('admin.admin-language') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.admin-language')); ?>"><?php echo e(__('admin.Admin Language')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.admin-validation-language') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.admin-validation-language')); ?>"><?php echo e(__('admin.Admin Validation')); ?></a></li>

                <li class="<?php echo e(Route::is('admin.website-language') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.website-language')); ?>"><?php echo e(__('admin.Frontend Language')); ?></a></li>
                <li class="<?php echo e(Route::is('admin.website-validation-language') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.website-validation-language')); ?>"><?php echo e(__('admin.Frontend Validation')); ?></a></li>
            </ul>
          </li>


          <li class="<?php echo e(Route::is('admin.general-setting') ? 'active' : ''); ?>">
          <p class="s-divide"><?php echo e(__('admin.Settings')); ?></p>

          <a class="nav-link" href="<?php echo e(route('admin.general-setting')); ?>">


           <div class="icon">
           <i class="fas fa-cog"></i>
           </div>
           <span><?php echo e(__('admin.Setting')); ?></span></a></li>
          <?php
              $logedInAdmin = Auth::guard('admin')->user();
          ?>

          <?php if($logedInAdmin->admin_type == 1): ?>

            <li  class="<?php echo e(Route::is('admin.clear-database') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.clear-database')); ?>">
             <div class="icon">
             <i class="fas fa-trash"></i>
             </div>
             <span><?php echo e(__('admin.Clear Database')); ?></span></a></li>

          <?php endif; ?>



          <li class="<?php echo e(Route::is('admin.contact-message') || Route::is('admin.show-contact-message') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.contact-message')); ?>">
           <div class="icon">
           <i class="fas fa-fa fa-envelope"></i>
           </div>
           <span><?php echo e(__('admin.Contact Message')); ?></span></a></li>


          <?php if($logedInAdmin->admin_type == 1): ?>

            <li class="<?php echo e(Route::is('admin.admin.index') ? 'active' : ''); ?>"><a class="nav-link" href="<?php echo e(route('admin.admin.index')); ?>">
             <div class="icon">
             <i class="fas fa-user"></i>
             </div>
             <span><?php echo e(__('admin.Admin list')); ?></span></a></li>

          <?php endif; ?>

        </ul>
    </aside>

  </div>

<?php /**PATH C:\xampp\htdocs\shopus\resources\views/admin/sidebar.blade.php ENDPATH**/ ?>